#include "DatabaseTree.h"
#include "ConnectionForm.h"
#include "MainForm.h"
#include "ResultTab.h"
#include "QueryTab.h"
#include <QAction>

/* 
	  
*/
DatabaseTree::DatabaseTree(QWidget* parent):QTreeWidget(parent)
{
	this->CreateActions();
	
	MainForm* mainForm = (MainForm*)(this->parent()->parent());	

	connect(this, SIGNAL(itemPressed(QTreeWidgetItem*, int)), mainForm, SLOT(DisplayTableData()));
}

/* 
	 ̽   Ʈ ۼ
*/
void DatabaseTree::MakeTreeView()
{
	//this->setCornerWidget(new QPushButton(QIcon("images/treeRefresh.png"), ""));

	ConnectionForm* connectionForm = ConnectionForm::getInstance();
	QSqlDatabase* db = connectionForm->GetDb();	
	QStringList views = db->tables(QSql::Views);
	QSqlQuery query;

	QTreeWidgetItem* databaseName = new QTreeWidgetItem(this, QStringList(db->databaseName()));
	databaseName->setIcon(0, QIcon("images/database.png"));

	//new QTreeWidgetItem(this, QStringList("Test:));

	// ̺ õ Ʈ 
	this->ReadEachTable(db, databaseName);

	// 信 õ Ʈ 
	QTreeWidgetItem* view = new QTreeWidgetItem(databaseName, QStringList("Views"));
	view->setIcon(0, QIcon("images/treeFolder.png"));

	query = QSqlQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS");

	while (query.next()) {
		QString dbName = query.value(0).toString();
		QString viewName = query.value(1).toString();
		
		if( dbName == ConnectionForm::getInstance()->GetDb()->databaseName() ){
			// ̺ Ʈ    ۰ ߺ  
			QList<QTreeWidgetItem*> itemList = this->findItems(viewName, Qt::MatchFixedString);
			delete itemList.at(0);
			
			//  Ʈ  
			QTreeWidgetItem* buffer = new QTreeWidgetItem(view, QStringList(viewName));
			buffer->setIcon(0, QIcon("images/treeView.png"));
		}
	 }

	QTreeWidgetItem* procedure = new QTreeWidgetItem(databaseName, QStringList("Stored Procs"));
	procedure->setIcon(0, QIcon("images/treeFolder.png"));

	query = QSqlQuery("show procedure status");

	 while (query.next()) {
		QString databaseName = query.value(0).toString();
		QString procedureName = query.value(1).toString();
		
		if( databaseName == ConnectionForm::getInstance()->GetDb()->databaseName() ){
			QTreeWidgetItem* buffer = new QTreeWidgetItem(procedure, QStringList(procedureName));
			buffer->setIcon(0, QIcon("images/treeProc.png"));
		}
	 }
	 
	 QTreeWidgetItem* function = new QTreeWidgetItem(databaseName, QStringList("Functions"));
	 function->setIcon(0, QIcon("images/treeFolder.png"));
	 
	 query = QSqlQuery("show function status");
	 
	 while (query.next()) {
		 QString databaseName = query.value(0).toString();
		 QString functionName = query.value(1).toString();
		 if( databaseName == ConnectionForm::getInstance()->GetDb()->databaseName() ){
			 QTreeWidgetItem* buffer = new QTreeWidgetItem(function, QStringList(functionName));
			 buffer->setIcon(0, QIcon("images/treeFunc.png"));
		 }
	 }
	 
	 QTreeWidgetItem* trigger = new QTreeWidgetItem(databaseName, QStringList("Triggers"));
	 trigger->setIcon(0, QIcon("images/treeFolder.png"));

	query = QSqlQuery("show triggers");

	 while (query.next()) {
		QString triggerName = query.value(0).toString();
		QTreeWidgetItem* buffer = new QTreeWidgetItem(trigger, QStringList(triggerName));
		buffer->setIcon(0, QIcon("images/treeTrigger.png"));
	 }
}

/* 
	Context Menu ̺Ʈ ߻ 
*/
void DatabaseTree::contextMenuEvent(QContextMenuEvent *event)
{
	if( this->currentItem() != 0 ){
		
		QSqlDatabase* db = ConnectionForm::getInstance()->GetDb();
		QString itemName = this->currentItem()->text(0);
		QString parentName;
		
		if( this->currentItem()->parent() != 0 ){
			parentName = this->currentItem()->parent()->text(0);
		}
		
		QMenu menu(this);
		
		if( itemName == "Stored Procs" || parentName =="Stored Procs"){
			
			if( itemName == "Stored Procs"){
				menu.addAction(this->createStoredProcAction);
			}
			// kang
			else{
				//menu.addAction(this->createStoredProcAction);
				menu.addAction(this->alterStoredProcAction);
				menu.addAction(this->dropStoredProcAction);
			}
		}
		
		else if( itemName == "Views" || parentName =="Views"){
			
			if( itemName == "Views"){
				menu.addAction(this->createViewAction);
			}
			else{
			//	menu.addAction(this->createViewAction);
				menu.addAction(this->alterViewAction);
				menu.addAction(this->dropViewAction);
				menu.addAction(this->renameViewAction);
			}
		}
		
		else if ( itemName == "Functions" || parentName =="Functions"){
			
			if( itemName == "Functions"){
				menu.addAction(this->createFuncAction);
			}
			else{
			//	menu.addAction(this->createFuncAction);
				menu.addAction(this->alterFuncAction);
				menu.addAction(this->dropFuncAction);
			}
		}
		
		else if ( itemName == "Triggers" || parentName =="Triggers"){
			
			if( itemName == "Triggers"){
				menu.addAction(this->createTriggerAction);
			}
			else{
		//		menu.addAction(this->createTriggerAction);
				menu.addAction(this->alterTriggerAction);
				menu.addAction(this->dropTriggerAction);
			}
		}
		
		else if( itemName == "Columns" || parentName == "Columns"){
			
			menu.addAction(this->manageColumnAction);				
		}
		
		else if( itemName == "Indexes" || parentName == "Indexes"){
			// ߿ ߰ κ...
		}
		
		else if ( itemName == "Tables" || parentName == "Tables"){
			if( itemName == "Tables"){
				menu.addAction(this->createTableAction);
			}
			else {
				menu.addAction(this->alterTableAction);
				menu.addAction(this->dropTableAction);
				menu.addAction(this->emptyTableAction);
				menu.addAction(this->renameTableAction);
				menu.addAction(this->relationshipAction);
				menu.addAction(this->viewDataAction);
				menu.addAction(this->exportToXMLAction);
			}
		}

		else if( itemName == db->databaseName() ){
			menu.addAction(this->createDatabaseAction);
			menu.addAction(this->dropDatabaseAction);
		}
		menu.exec(event->globalPos());
	}
}

/*
	̺  о 
*/
void DatabaseTree::ReadEachTable(QSqlDatabase* db, QTreeWidgetItem* databaseName)
{
	QStringList tables = db->tables(QSql::Tables);

	QTreeWidgetItem* tableParent = new QTreeWidgetItem(databaseName, QStringList("Tables"));
	tableParent->setIcon(0, QIcon("images/treeFolder.png"));

	//  ̺ о ƾ
	for (int i = 0; i < tables.count(); i++) {
        QTreeWidgetItem *item = new QTreeWidgetItem(tableParent, QStringList(tables[i]));
		item->setIcon(0, QIcon("images/treeTable.png"));
		QSqlRecord tableColumn = db->record(tables[i]);
		
		QTreeWidgetItem* columns = new QTreeWidgetItem(item, QStringList("Columns"));
		columns->setIcon(0, QIcon("images/treeFolder.png"));

		QSqlQuery query ("desc " + tables[i]);

		 while (query.next()) {
			QString columnName = query.value(0).toString();
			QString pkState = query.value(3).toString();

			QTreeWidgetItem* buffer = new QTreeWidgetItem(columns, QStringList(columnName));
			
			if( pkState == "PRI"){
				buffer->setIcon(0, QIcon("images/treePk.png"));
			}
			else{
				buffer->setIcon(0, QIcon("images/treeColumn.png"));
			}
		 }

		// index о κ
		QTreeWidgetItem* indexes = new QTreeWidgetItem(item, QStringList("Indexes"));
		indexes->setIcon(0, QIcon("images/treeFolder.png"));
		
		query = QSqlQuery("show indexes from "+tables[i]);

		 while (query.next()) {
			 QString keyName = query.value(2).toString();
			 QString columnName = query.value(4).toString();
			 QString index = columnName + ", " + keyName;

			QTreeWidgetItem* buffer = new QTreeWidgetItem(indexes, QStringList(index));
			buffer->setIcon(0, QIcon("images/treeIndex.png"));
		 }
    }
}

/* 
	Action  
*/
void DatabaseTree::CreateActions()
{
	MainForm* mainForm = (MainForm*)(this->parent()->parent());

	this->createTableAction = new QAction(tr("Create Table"), this);

	connect(this->createTableAction, SIGNAL(triggered()), mainForm, SLOT(CreateTable()));

	this->alterTableAction = new QAction(tr("Alter Table"), this);
	connect(this->alterTableAction, SIGNAL(triggered()), mainForm, SLOT(AlterTable()));

	this->dropTableAction = new QAction(tr("Drop Table"), this);
	connect(this->dropTableAction, SIGNAL(triggered()), mainForm, SLOT(DropTable()));

	this->emptyTableAction = new QAction(tr("Empty Table"), this);
	connect(this->emptyTableAction, SIGNAL(triggered()), mainForm, SLOT(EmptyTable()));

	this->renameTableAction = new QAction(tr("Rename Table"), this);
	connect(this->renameTableAction, SIGNAL(triggered()), mainForm, SLOT(RenameTable()));

	this->viewDataAction = new QAction(tr("View Data"), this);
    connect(this->viewDataAction, SIGNAL(triggered()), mainForm, SLOT(DisplayTableData()));

	this->createStoredProcAction = new QAction(tr("Create Stored Procedure"), this);
    connect(this->createStoredProcAction, SIGNAL(triggered()), mainForm, SLOT(CreateStoredProcedure()));

	this->alterStoredProcAction = new QAction(tr("Alter Stored Procedure"), this);
    connect(this->alterStoredProcAction, SIGNAL(triggered()), mainForm, SLOT(AlterStoredProcedure()));

	this->dropStoredProcAction = new QAction(tr("Drop Stored Procedure"), this);
    connect(this->dropStoredProcAction, SIGNAL(triggered()), mainForm, SLOT(DropStoredProcedure()));

	this->createFuncAction = new QAction(tr("Create Function"), this);
	connect(this->createFuncAction, SIGNAL(triggered()), mainForm, SLOT(CreateFunction()));

	this->alterFuncAction = new QAction(tr("Alter Function"), this);
	connect(this->alterFuncAction, SIGNAL(triggered()), mainForm, SLOT(AlterFunction()));

	this->dropFuncAction = new QAction(tr("Drop Function"), this);
	connect(this->dropFuncAction, SIGNAL(triggered()), mainForm, SLOT(DropFunction()));

	this->manageColumnAction = new QAction(tr("Manage Column"), this);
	connect(this->manageColumnAction, SIGNAL(triggered()), mainForm, SLOT(AlterTable()));

	this->createViewAction = new QAction(tr("Create View"), this);
	connect(this->createViewAction, SIGNAL(triggered()), mainForm, SLOT(CreateView()));

	this->alterViewAction = new QAction(tr("Alter View"), this); 
	connect(this->alterViewAction, SIGNAL(triggered()), mainForm, SLOT(AlterView()));

	this->dropViewAction = new QAction(tr("Drop View"), this);
	connect(this->dropViewAction, SIGNAL(triggered()), mainForm, SLOT(DropView()));

	this->renameViewAction = new QAction(tr("Rename View"), this);
	connect(this->renameViewAction, SIGNAL(triggered()), mainForm, SLOT(RenameView()));

	this->createTriggerAction = new QAction(tr("Create Trigger"), this);
	connect(this->createTriggerAction, SIGNAL(triggered()), mainForm, SLOT(CreateTrigger()));

	this->alterTriggerAction = new QAction(tr("Alter Trigger"), this);   
	connect(this->alterTriggerAction, SIGNAL(triggered()), mainForm, SLOT(AlterTrigger()));

	this->dropTriggerAction = new QAction(tr("Drop Trigger"), this);
	connect(this->dropTriggerAction, SIGNAL(triggered()), mainForm, SLOT(DropTrigger()));

	this->exportToXMLAction = new QAction(tr("Export To XML"), this);
	connect(this->exportToXMLAction, SIGNAL(triggered()), mainForm, SLOT(ExportToXML()));

	this->createDatabaseAction = new QAction(tr("Create Database"), this);
	connect(this->createDatabaseAction, SIGNAL(triggered()), mainForm, SLOT(CreateDatabase()));

	this->dropDatabaseAction = new QAction(tr("Drop Database"), this);
	connect(this->dropDatabaseAction, SIGNAL(triggered()), mainForm, SLOT(DropDatabase()));

	this->relationshipAction = new QAction(tr("RelationShip/FK"), this);
	connect(this->relationshipAction, SIGNAL(triggered()), mainForm, SLOT(SetRelation()));
}

/* 
	  
*/
DatabaseTree::~DatabaseTree()
{
}
